@extends('layouts.admin')

@section('content')
<h1>Backups</h1>

<form action="{{ route('admin.backup.run') }}" method="POST">
    @csrf
    <button type="submit" class="btn btn-primary">Run Backup</button>
</form>

<table class="table mt-3">
    <thead>
        <tr>
            <th>File Name</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        @foreach($backups as $backup)
        <tr>
            <td>{{ basename($backup) }}</td>
            <td>
                <a href="{{ route('admin.backup.download', basename($backup)) }}" class="btn btn-success btn-sm">Download</a>
                <form action="{{ route('admin.backup.delete', basename($backup)) }}" method="POST" style="display:inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                </form>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>
@endsection
